#!/bin/bash
#-----setting path for fsl===========
source ~petr/fsl5.sh
#-----path for afni===========
setting set path = $path /data/brutus_data0/freeware/afni
echo $path

#export PATH=$PATH:/data/brutus_data0/freeware/afni
echo $COMMAND
#-----setting path path  for denoising===========
export DNPATH=/data/brutus_data1/home/els/pipeline/mrtrix3/mrtrix3/release/bin
PATH=/data/brutus_data1/home/els/pipeline/mrtrix3/mrtrix3/release/bin:$PATH


direct_list=`ls -d ACP1348 ACP1349 ACP1359 ACP1368 ACP1369`
echo  $direct_list
spath=`pwd`
for cur_dir  in  $direct_list
do
date
cd $cur_dir
echo $cur_dir

echo ' --- denoising ----'

mv *rfMRI_REST1_AP.nii.gz R1_AP.nii.gz
mv *rfMRI_REST1_PA.nii.gz R1_PA.nii.gz

mv *rfMRI_REST2_AP.nii.gz R2_AP.nii.gz
mv *rfMRI_REST2_PA.nii.gz R2_PA.nii.gz

$DNPATH/dwidenoise -noise sigma11.nii R1_AP.nii.gz dn1_AP.nii.gz
$DNPATH/dwidenoise -noise sigma12.nii R1_PA.nii.gz dn1_PA.nii.gz

$DNPATH/dwidenoise -noise sigma21.nii R2_AP.nii.gz dn2_AP.nii.gz
$DNPATH/dwidenoise -noise sigma22.nii R2_PA.nii.gz dn2_PA.nii.gz


echo '--------------topup run1-----------'
mv *rfMRI_REST1_AP_SBRef.nii.gz SBRef1_AP.nii.gz
mv *rfMRI_REST1_PA_SBRef.nii.gz SBRef1_PA.nii.gz

$FSLDIR/bin/fslroi SBRef1_AP.nii.gz AP1_b0.nii.gz 0 1
$FSLDIR/bin/fslroi SBRef1_PA.nii.gz PA1_b0.nii.gz 0 1
$FSLDIR/bin/fslmerge -t A2P_P2A_b01 AP1_b0.nii.gz PA1_b0.nii.gz

$FSLDIR/bin/topup --imain=A2P_P2A_b01 --datain=../aqparam.txt --config=../b02b0.cnf --out=my_topup_results1 --iout=my1_hifi_b01
$FSLDIR/bin/fslmaths my1_hifi_b01.nii.gz -Tmean brain1

$FSLDIR/bin/applytopup --imain=dn1_AP.nii.gz,dn1_PA.nii.gz  --inindex=1,2 -a ../aqparam.txt --topup=my_topup_results1 --out=my1_hifi1
$FSLDIR/bin/applytopup --imain=dn1_PA.nii.gz,dn1_AP.nii.gz  --inindex=2,1 -a ../aqparam.txt --topup=my_topup_results1 --out=my1_hifi2
$FSLDIR/bin/fslmerge -t denoise1.nii my1_hifi1.nii.gz my1_hifi2.nii.gz
#rm my1_hifi* brain* my_top* *b*.nii.gz

echo '------------align center run1-----------------'
export PATH=$PATH:/data/brutus_data0/freeware/afni
@Align_Centers -base MNI_caez_N27+tlrc. -dset denoise1.nii.gz

echo '----------spatial normalization run1 ---------------'
$FSLDIR/bin/fslmaths denoise1_shft.nii.gz -Tmean Avg_R1
$FSLDIR/bin/fslmaths Avg_R1.nii.gz -thr 100 Avg_R1
$FSLDIR/bin/bet Avg_R1.nii.gz test -f 0.2
$FSLDIR/bin/bet test.nii.gz Avg_epi1 -f 0.2

$FSLDIR/bin/flirt -in Avg_epi1.nii.gz  -ref ../ENIGMA_Template.nii.gz -out Avg1.nii -omat MatReg1.txt
$FSLDIR/bin/flirt -in denoise1_shft.nii.gz  -ref ../ENIGMA_Template.nii.gz  -applyxfm -init MatReg1.txt -out rsfMRI_R1
#rm denoise_shft.nii* Avg* MatR* test*
date

echo '--------------------topup run2-----------'
mv *rfMRI_REST2_AP_SBRef.nii.gz SBRef2_AP.nii.gz
mv *rfMRI_REST2_PA_SBRef.nii.gz SBRef2_PA.nii.gz

$FSLDIR/bin/fslroi SBRef2_AP.nii.gz AP2_b0.nii.gz 0 1
$FSLDIR/bin/fslroi SBRef2_PA.nii.gz PA2_b0.nii.gz 0 1
$FSLDIR/bin/fslmerge -t A2P_P2A_b02 AP2_b0.nii.gz PA2_b0.nii.gz

$FSLDIR/bin/topup --imain=A2P_P2A_b02 --datain=../aqparam.txt --config=../b02b0.cnf --out=my_topup_results2 --iout=my2_hifi_b02
$FSLDIR/bin/fslmaths my2_hifi_b02.nii.gz -Tmean brain2

$FSLDIR/bin/applytopup --imain=dn2_AP.nii.gz,dn2_PA.nii.gz  --inindex=1,2 -a ../aqparam.txt --topup=my_topup_results2 --out=my2_hifi1
$FSLDIR/bin/applytopup --imain=dn2_PA.nii.gz,dn2_AP.nii.gz  --inindex=2,1 -a ../aqparam.txt --topup=my_topup_results2 --out=my2_hifi2
$FSLDIR/bin/fslmerge -t denoise2.nii my2_hifi1.nii.gz my2_hifi2.nii.gz
#rm my1_hifi* brain* my_top* *b*.nii.gz

echo '-------------align center run2----------'
export PATH=$PATH:/data/brutus_data0/freeware/afni
@Align_Centers -base MNI_caez_N27+tlrc. -dset denoise2.nii.gz

echo '---------spatial normalization run2 ------------------'
$FSLDIR/bin/fslmaths denoise2_shft.nii.gz -Tmean Avg_R2
$FSLDIR/bin/fslmaths Avg_R2.nii.gz -thr 100 Avg_R2
$FSLDIR/bin/bet Avg_R2.nii.gz test2 -f 0.2
$FSLDIR/bin/bet test2.nii.gz Avg_epi2 -f 0.2

$FSLDIR/bin/flirt -in Avg_epi2.nii.gz  -ref ../ENIGMA_Template.nii.gz -out Avg2.nii -omat MatReg2.txt
$FSLDIR/bin/flirt -in denoise2_shft.nii.gz  -ref ../ENIGMA_Template.nii.gz  -applyxfm -init MatReg2.txt -out rsfMRI_R2
date
rm A* b* d* my* Mat* PA* test* sigma*
cd ..
cd $spath
done

cd $spath

